#include "POF/Gradient_generator_fullcal.h"
#include <math.h>
#include <cmath>
#include <stdexcept>

using namespace std;

extern double ccon_gradient[n_label][MAX_n_class][MAX_batch_size];
extern double test_case_ccon_gradient[n_label][MAX_n_class][MAX_n_internal_test_case];

double test_case_ccon_gradient_tmp[n_label][MAX_n_class][MAX_n_internal_test_case][3];

extern void flatten_ccon_gradient(int n_label, int batch_size, int n_class, double ccon_gradient_list[]);

extern void flatten_test_case_ccon_gradient(int n_label, int n_internal_test_case, int n_class, double test_case_ccon_gradient_list[]);

void fullcalc_grad_ccon(struct NN_data* nn_data, struct User_parameter* user_parameter, struct Indata* indata, double ccon_gradient_list[]) {

	for (int pm = 0; pm < n_label; pm++) {
		for (int j = 0; j < nn_data->batch_size; j++) {
			double approx_loss_class[nn_data->n_class];
			double expsum = 0;
			
			for (int i = 0; i < nn_data->n_class; i++) {
				int tmp = nn_data->normalclass[pm][j]; // KKY: check
				nn_data->normalclass[pm][j] = i;
				// KKY: assumption:normaltable, posterior are already set.
				approx_loss_class[i] = calc_approx_loss(nn_data, indata, user_parameter);
				// cout<<approx_loss_class[i]<<endl;
				expsum += exp(nn_data->ccon_w[pm][i][j]);
				nn_data->normalclass[pm][j] = tmp;
			}
			for (int i = 0; i < nn_data->n_class; i++) {
				ccon_gradient[pm][i][j] = 0;
				for (int k = 0; k < nn_data->n_class; k++) {
					if (k == i)
						ccon_gradient[pm][i][j] += approx_loss_class[k] * (exp(nn_data->ccon_w[pm][k][j]) / expsum);
					ccon_gradient[pm][i][j] += -approx_loss_class[k] * (exp(nn_data->ccon_w[pm][k][j]) * exp(nn_data->ccon_w[pm][i][j]) / expsum / expsum);
				}
				// NO_UPDATE
			}
		}
	}

	flatten_ccon_gradient(n_label, nn_data->batch_size, nn_data->n_class, ccon_gradient_list);
}

void fullcalc_grad_test_case_ccon(struct NN_data* nn_data, struct User_parameter* user_parameter, struct Indata* indata, double test_case_ccon_gradient_list[]) {

	double xi = user_parameter->xi;
	int n_rank = user_parameter->n_rank;
	int n_internal_test_case = nn_data->n_internal_test_case;
	int n_class = nn_data->n_class;

	Indata* new_indata(new Indata);
	*new_indata = *indata;
	// memcpy(new_indata, indata, sizeof(*indata));

	double main_approxloss = calc_approx_loss(nn_data, indata, user_parameter);

	//일단 safe, unsafe한 intest 개수부터 세기
	int safe_cnt = 0, unsafe_cnt = 0;
	for (int j = 0; j < n_internal_test_case; j++)
	{
		safe_cnt += (nn_data->ans[0][j]);
		unsafe_cnt += !(nn_data->ans[0][j]);
	}
	
	//각 table에 대한 approx 결과정리
	double approx_loss_table[17][17][17][17], multiplier_table[16][3], grad_table[16][3];
	try{
		for (int safe_pxi = 0; safe_pxi <= safe_cnt; safe_pxi++)
			for (int safe_mxi = 0; safe_mxi <= safe_pxi; safe_mxi++)
				for (int unsafe_pxi = 0; unsafe_pxi <= unsafe_cnt; unsafe_pxi++)
					for (int unsafe_mxi = 0; unsafe_mxi <= unsafe_pxi; unsafe_mxi++)
					{
						new_indata->normaltable[0][0][0][0] = unsafe_mxi;
						new_indata->normaltable[0][0][0][1] = unsafe_pxi;
						//'binary에서 1번째가 0번째보다 xi이상 더 크다'는 '0번째가 1번째보다 xi만큼은 작지 않다'의 반대. 따라서 다음과 같이 계산
						new_indata->normaltable[0][0][1][0] = unsafe_cnt - unsafe_pxi;
						new_indata->normaltable[0][0][1][1] = unsafe_cnt - unsafe_mxi;
						new_indata->normaltable[0][1][0][0] = safe_mxi;
						new_indata->normaltable[0][1][0][1] = safe_pxi;
						new_indata->normaltable[0][1][1][0] = safe_cnt - safe_pxi;
						new_indata->normaltable[0][1][1][1] = safe_cnt - safe_mxi;
						set_posterior(nn_data, user_parameter, new_indata);
						approx_loss_table[unsafe_pxi][unsafe_mxi][safe_pxi][safe_mxi] = calc_approx_loss(nn_data, new_indata, user_parameter);
						if(isnan(approx_loss_table[unsafe_pxi][unsafe_mxi][safe_pxi][safe_mxi]))
							cout<<safe_pxi<<safe_mxi<<unsafe_pxi<<unsafe_mxi<<approx_loss_table[safe_pxi][safe_mxi][unsafe_pxi][unsafe_mxi]<<endl;
						//안전한 intest중 +xi 개수, -xi 개수, 위험한 intest중 +xi 개수, -xi 개수에 따른 approx_loss 값 출력
					}
	}
	catch (exception& e)
	{
		cout<<e.what()<<endl;
	}

	//각 j별로 곱해지는 계수 계산-softmax, softmax 미분
	// cout<<"multiplier_table"<<endl;
	for (int j = 0; j < n_internal_test_case; j++) {
		multiplier_table[j][0] = exp(nn_data->test_case_ccon_w[0][0][j] - xi) / (exp(nn_data->test_case_ccon_w[0][0][j] - xi) + exp(nn_data->test_case_ccon_w[0][1][j]));
		multiplier_table[j][1] = exp(nn_data->test_case_ccon_w[0][0][j] + xi) / (exp(nn_data->test_case_ccon_w[0][0][j] + xi) + exp(nn_data->test_case_ccon_w[0][1][j])) - exp(nn_data->test_case_ccon_w[0][0][j] - xi) / (exp(nn_data->test_case_ccon_w[0][0][j] - xi) + exp(nn_data->test_case_ccon_w[0][1][j]));
		multiplier_table[j][2] = 1 - exp(nn_data->test_case_ccon_w[0][0][j] + xi) / (exp(nn_data->test_case_ccon_w[0][0][j] + xi) + exp(nn_data->test_case_ccon_w[0][1][j]));
		grad_table[j][0] = exp(nn_data->test_case_ccon_w[0][0][j] - xi) / (exp(nn_data->test_case_ccon_w[0][0][j] - xi) + exp(nn_data->test_case_ccon_w[0][1][j])) - pow(exp(nn_data->test_case_ccon_w[0][0][j] - xi), 2) / pow((exp(nn_data->test_case_ccon_w[0][0][j] - xi) + exp(nn_data->test_case_ccon_w[0][1][j])), 2);
		grad_table[j][2] = -exp(nn_data->test_case_ccon_w[0][0][j] + xi) / (exp(nn_data->test_case_ccon_w[0][0][j] + xi) + exp(nn_data->test_case_ccon_w[0][1][j])) + pow(exp(nn_data->test_case_ccon_w[0][0][j] + xi), 2) / pow((exp(nn_data->test_case_ccon_w[0][0][j] + xi) + exp(nn_data->test_case_ccon_w[0][1][j])), 2);
		grad_table[j][1] = -grad_table[j][0] - grad_table[j][2];
		// cout<<multiplier_table[j][0]<<" "<<multiplier_table[j][1]<<" "<<multiplier_table[j][2]<<" "<<grad_table[j][0]<<" "<<grad_table[j][1]<<" "<<grad_table[j][2]<<endl;
		//각 intest에 대해서 (1, 1)확률, (0,1)확률, (0,0)확률, (1,1)확률 미분값, (0,1)확률 미분값, (0,0)확률 미분값 (여기서 미분은 test_case_ccon_w에 대한 미분)
	}

	//실제 계산
	for (int j = 0; j < n_internal_test_case; j++) {
		test_case_ccon_gradient[0][0][j] = 0;
		double tmp_multi_table[3];

		//계산을 진행하는 intest에 대해서는 확률 대신 미분값이 계수에 곱해짐, 따라서 확률을 미분값으로 임시 대체, 마지막에 원상복귀
		tmp_multi_table[0] = multiplier_table[j][0];
		tmp_multi_table[1] = multiplier_table[j][1];
		tmp_multi_table[2] = multiplier_table[j][2];
		multiplier_table[j][0] = grad_table[j][0];
		multiplier_table[j][1] = grad_table[j][1];
		multiplier_table[j][2] = grad_table[j][2];

		//register int: "변수를 가능하면 register(CPU 내부의 가장 빠른 (그리고 작은) 기억장치)에 보관해라. 계속 써야 하니까"
		register int pxi[2] = {}, mxi[2] = {};
		//pxi[0]은 위험한 intest중 +xi해당하는 개수, pxi[1]은 안전한 intest중 +xi해당하는 개수, mxi[0]은 위험한 intest중 -xi해당하는 개수, mxi[1]은 안전한 intest중 -xi해당하는 개수
		
		register double value = 1;//���

		try{
			for (int in0 = 0; in0 < 3; in0++)//0��° intest: 0�̸� +xi, -xi �Ѵ� 0, 1�̸� +xi�� 1, 2�� �Ѵ� 1, 15��° intest���� ��������
			{
				//value에 각 확률 또는 grad값을 곱해서 계수 만들기
				value *= multiplier_table[0][in0];

				//for가 안쪽으로 들어갈수록 누적해서 안전/위험 +xi, -xi 개수 세어주기 (나오면서 다시 빼기)
				//ans[0][j]=0이면 위험한 intest=>pxi[0], mxi[0]값 변화
				//ans[0][j]=1이면 안전한 intest=>pxi[1], mxi[1]값 변화
				pxi[nn_data->ans[0][0]] += (in0 < 2);
				mxi[nn_data->ans[0][0]] += (in0 < 1);
				for (int in1 = 0; in1 < 3; in1++)
				{
					value *= multiplier_table[1][in1];
					pxi[nn_data->ans[0][1]] += (in1 < 2);
					mxi[nn_data->ans[0][1]] += (in1 < 1);
					for (int in2 = 0; in2 < 3; in2++)
					{
						value *= multiplier_table[2][in2];
						pxi[nn_data->ans[0][2]] += (in2 < 2);
						mxi[nn_data->ans[0][2]] += (in2 < 1);
						for (int in3 = 0; in3 < 3; in3++)
						{
							value *= multiplier_table[3][in3];
							pxi[nn_data->ans[0][3]] += (in3 < 2);
							mxi[nn_data->ans[0][3]] += (in3 < 1);
							for (int in4 = 0; in4 < 3; in4++)
							{
								value *= multiplier_table[4][in4];
								pxi[nn_data->ans[0][4]] += (in4 < 2);
								mxi[nn_data->ans[0][4]] += (in4 < 1);
								for (int in5 = 0; in5 < 3; in5++)
								{
									value *= multiplier_table[5][in5];
									pxi[nn_data->ans[0][5]] += (in5 < 2);
									mxi[nn_data->ans[0][5]] += (in5 < 1);
									for (int in6 = 0; in6 < 3; in6++)
									{
										value *= multiplier_table[6][in6];
										pxi[nn_data->ans[0][6]] += (in6 < 2);
										mxi[nn_data->ans[0][6]] += (in6 < 1);
										for (int in7 = 0; in7 < 3; in7++)
										{
											value *= multiplier_table[7][in7];
											pxi[nn_data->ans[0][7]] += (in7 < 2);
											mxi[nn_data->ans[0][7]] += (in7 < 1);
											for (int in8 = 0; in8 < 3; in8++)
											{
												value *= multiplier_table[8][in8];
												pxi[nn_data->ans[0][8]] += (in8 < 2);
												mxi[nn_data->ans[0][8]] += (in8 < 1);
												for (int in9 = 0; in9 < 3; in9++)
												{
													value *= multiplier_table[9][in9];
													pxi[nn_data->ans[0][9]] += (in9 < 2);
													mxi[nn_data->ans[0][9]] += (in9 < 1);
													for (int in10 = 0; in10 < 3; in10++)
													{
														value *= multiplier_table[10][in10];
														pxi[nn_data->ans[0][10]] += (in10 < 2);
														mxi[nn_data->ans[0][10]] += (in10 < 1);
														for (int in11 = 0; in11 < 3; in11++)
														{
															value *= multiplier_table[11][in11];
															pxi[nn_data->ans[0][11]] += (in11 < 2);
															mxi[nn_data->ans[0][11]] += (in11 < 1);
															for (int in12 = 0; in12 < 3; in12++)
															{
																value *= multiplier_table[12][in12];
																pxi[nn_data->ans[0][12]] += (in12 < 2);
																mxi[nn_data->ans[0][12]] += (in12 < 1);
																for (int in13 = 0; in13 < 3; in13++)
																{
																	value *= multiplier_table[13][in13];
																	pxi[nn_data->ans[0][13]] += (in13 < 2);
																	mxi[nn_data->ans[0][13]] += (in13 < 1);
																	for (register int in14 = 0; in14 < 3; in14++)
																	{
																		value *= multiplier_table[14][in14];
																		pxi[nn_data->ans[0][14]] += (in14 < 2);
																		mxi[nn_data->ans[0][14]] += (in14 < 1);
																		for (register int in15 = 0; in15 < 3; in15++)
																		{
																			// 마지막 intest에 대해서는 memory operation 수를 줄이기 위해 pxi, mxi에 더했다가 다시 빼는 대신 다음 식에 직접 계산, (!(nn_data->ans[0][15]))는 ans[0][15]가 0일 때 1, 1일때 0
																			test_case_ccon_gradient[0][0][j] += value * multiplier_table[15][in15] * approx_loss_table[pxi[0]+(!(nn_data->ans[0][15]))* (in15 < 2)][mxi[0] + (!nn_data->ans[0][15]) * (in15 < 1)][pxi[1]+ (nn_data->ans[0][15])* (in15 < 2)][mxi[1]+ (nn_data->ans[0][15]) * (in15 < 1)];
																			if(isnan(value * multiplier_table[15][in15] * approx_loss_table[pxi[0]+(!(nn_data->ans[0][15]))* (in15 < 2)][mxi[0] + (!nn_data->ans[0][15]) * (in15 < 1)][pxi[1]+ (nn_data->ans[0][15])* (in15 < 2)][mxi[1]+ (nn_data->ans[0][15]) * (in15 < 1)])){
																				exception e;
																				long double arr[] = {in0, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, value * multiplier_table[15][in15] * approx_loss_table[pxi[0]+(!(nn_data->ans[0][15]))* (in15 < 2)][mxi[0] + (!nn_data->ans[0][15]) * (in15 < 1)][pxi[1]+ (nn_data->ans[0][15])* (in15 < 2)][mxi[1]+ (nn_data->ans[0][15]) * (in15 < 1)]};
																				// cout<<value * multiplier_table[15][in15] * approx_loss_table[pxi[0]+(!(nn_data->ans[0][15]))* (in15 < 2)][mxi[0] + (!nn_data->ans[0][15]) * (in15 < 1)][pxi[1]+ (nn_data->ans[0][15])* (in15 < 2)][mxi[1]+ (nn_data->ans[0][15]) * (in15 < 1)]<<endl;
																			}
																			// printf("%lf\n", value* multiplier_table[15][in15] * approx_loss_table[pxi[0] + (!(nn_data->ans[0][15])) * (in15 < 2)][mxi[0] + (!(nn_data->ans[0][15])) * (in15 < 1)][pxi[1] + (nn_data->ans[0][15]) * (in15 < 2)][mxi[1] + (nn_data->ans[0][15]) * (in15 < 1)]);
																			// 이번 intest의 조합에서 j번째 intest에 대한 grad에 더해지는 항의 값 출력, 실제로 돌릴 때는 stdout의 시간 소모가 크니 반드시 주석처리
																		}
																		pxi[nn_data->ans[0][14]] -= (in14 < 2);
																		mxi[nn_data->ans[0][14]] -= (in14 < 1);
																		value /= multiplier_table[14][in14];
																	}
																	pxi[nn_data->ans[0][13]] -= (in13 < 2);
																	mxi[nn_data->ans[0][13]] -= (in13 < 1);
																	value /= multiplier_table[13][in13];
																}
																pxi[nn_data->ans[0][12]] -= (in12 < 2);
																mxi[nn_data->ans[0][12]] -= (in12 < 1);
																value /= multiplier_table[12][in12];
															}
															pxi[nn_data->ans[0][11]] -= (in11 < 2);
															mxi[nn_data->ans[0][11]] -= (in11 < 1);
															value /= multiplier_table[11][in11];
														}
														pxi[nn_data->ans[0][10]] -= (in10 < 2);
														mxi[nn_data->ans[0][10]] -= (in10 < 1);
														value /= multiplier_table[10][in10];
													}
													pxi[nn_data->ans[0][9]] -= (in9 < 2);
													mxi[nn_data->ans[0][9]] -= (in9 < 1);
													value /= multiplier_table[9][in9];
												}
												pxi[nn_data->ans[0][8]] -= (in8 < 2);
												mxi[nn_data->ans[0][8]] -= (in8 < 1);
												value /= multiplier_table[8][in8];
											}
											pxi[nn_data->ans[0][7]] -= (in7 < 2);
											mxi[nn_data->ans[0][7]] -= (in7 < 1);
											value /= multiplier_table[7][in7];
										}
										pxi[nn_data->ans[0][6]] -= (in6 < 2);
										mxi[nn_data->ans[0][6]] -= (in6 < 1);
										value /= multiplier_table[6][in6];
									}
									pxi[nn_data->ans[0][5]] -= (in5 < 2);
									mxi[nn_data->ans[0][5]] -= (in5 < 1);
									value /= multiplier_table[5][in5];
								}
								pxi[nn_data->ans[0][4]] -= (in4 < 2);
								mxi[nn_data->ans[0][4]] -= (in4 < 1);
								value /= multiplier_table[4][in4];
							}
							pxi[nn_data->ans[0][3]] -= (in3 < 2);
							mxi[nn_data->ans[0][3]] -= (in3 < 1);
							value /= multiplier_table[3][in3];
						}
						pxi[nn_data->ans[0][2]] -= (in2 < 2);
						mxi[nn_data->ans[0][2]] -= (in2 < 1);
						value /= multiplier_table[2][in2];
					}
					pxi[nn_data->ans[0][1]] -= (in1 < 2);
					mxi[nn_data->ans[0][1]] -= (in1 < 1);
					value /= multiplier_table[1][in1];
				}
				pxi[nn_data->ans[0][0]] -= (in0 < 2);
				mxi[nn_data->ans[0][0]] -= (in0 < 1);
				value /= multiplier_table[0][in0];
			}
		}
		catch(long double arr[]){
			cout<<j<<endl;
			cout<<arr[0]<<arr[1]<<arr[2]<<arr[3]<<arr[4]<<arr[5]<<arr[6]<<arr[7]<<arr[8]<<arr[9]<<arr[10]<<arr[11]<<arr[12]<<arr[13]<<arr[14]<<arr[15]<<endl;
			cout<<arr[16]<<endl;
		}
		
		multiplier_table[j][0] = tmp_multi_table[0];
		multiplier_table[j][1] = tmp_multi_table[1];
		multiplier_table[j][2] = tmp_multi_table[2];
		// printf("%d %lf\n", nn_data->ans[0][j], test_case_ccon_gradient[0][0][j]);
		test_case_ccon_gradient[0][1][j] = -test_case_ccon_gradient[0][0][j];
	}

	delete new_indata;

	flatten_test_case_ccon_gradient(n_label, n_internal_test_case, n_class, test_case_ccon_gradient_list);
}